/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.api;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public interface IRenderedTankUpgrade {
    public void setTankRenderInfoUpdateCallback(Consumer<TankRenderInfo> var1);

    public void forceUpdateTankRenderInfo();

    public static class TankRenderInfo {
        private static final String FLUID_REGISTRY_NAME_TAG = "fluidRegistryName";
        private static final String FILL_RATIO_TAG = "fillRatio";
        @Nullable
        private ResourceLocation fluidRegistryName;
        private float fillRatio;

        public TankRenderInfo() {
            this(null, 0.0f);
        }

        public TankRenderInfo(@Nullable ResourceLocation fluidRegistryName, float fillRatio) {
            this.fluidRegistryName = fluidRegistryName;
            this.fillRatio = fillRatio;
        }

        public CompoundNBT serialize() {
            CompoundNBT ret = new CompoundNBT();
            if (this.fluidRegistryName != null) {
                ret.func_74778_a(FLUID_REGISTRY_NAME_TAG, this.fluidRegistryName.toString());
                ret.func_74776_a(FILL_RATIO_TAG, this.fillRatio);
            }
            return ret;
        }

        public static TankRenderInfo deserialize(CompoundNBT tag) {
            if (tag.func_74764_b(FLUID_REGISTRY_NAME_TAG)) {
                return new TankRenderInfo(new ResourceLocation(tag.func_74779_i(FLUID_REGISTRY_NAME_TAG)), tag.func_74760_g(FILL_RATIO_TAG));
            }
            return new TankRenderInfo();
        }

        public void setFluid(Fluid fluid) {
            this.fluidRegistryName = fluid.getRegistryName();
        }

        public Optional<Fluid> getFluid() {
            return Optional.ofNullable((Fluid)ForgeRegistries.FLUIDS.getValue(this.fluidRegistryName));
        }

        public void setFillRatio(float fillRatio) {
            this.fillRatio = fillRatio;
        }

        public float getFillRatio() {
            return this.fillRatio;
        }
    }
}

